# System Overview

Duplicator Pro is a premium WordPress plugin for creating complete website backups, performing site migrations, and cloning WordPress installations.

## Core Concepts

**Package** → contains **Database Export** + **File Archive** → stored in **Storage Locations** → restored by **Installer**

## Key Features

- Complete WordPress site backup (database + files)
- Multi-format archive support (DupArchive, ZIP)
- Multiple storage destinations (Local, Amazon S3, Dropbox, Google Drive, FTP, etc.)
- Standalone installer for site restoration
- Scheduled automatic backups
- Migration and cloning capabilities
- Multisite support
- Large site handling with chunked processing

## Architecture Components

### Two-Phase Design

**Phase 1: Plugin (Backup Creation)**
- Runs within WordPress environment
- Creates packages containing database dumps and file archives
- Manages storage destinations
- Handles scheduled backups

**Phase 2: Installer (Restoration)**
- Standalone PHP script (independent of WordPress)
- Extracts archives and restores databases
- Performs search/replace operations
- Bootstraps new WordPress installation

### Core Systems

**Package System**
- `DupPackage` - Main package logic and orchestration
- `BuildProgress` - Build tracking and progress monitoring
- `PackageArchive` - File scanning and archive creation
- `DatabasePkg` - Database export and serialization

**Storage System**
- `AbstractStorageEntity` - Base class for all storage providers
- Modular addon architecture for cloud providers
- Upload tracking via `UploadInfo` entities
- Chunked upload support for large files

**Entity System**
- JSON-serialized configuration objects
- Database persistence layer
- Abstract base classes for entities
- Validation and sanitization

**Template System**
- MVC pattern with controllers and views
- `TplMng` for template rendering
- Separation of logic and presentation

## Technology Stack

- **Language**: PHP 7.4+ with strict typing
- **Framework**: WordPress Plugin API
- **Database**: WordPress `wpdb` abstraction layer
- **Archive Formats**: DupArchive (custom), ZIP (via ZipArchive/shell)
- **Storage**: Local filesystem + cloud provider APIs
- **Frontend**: Vanilla JavaScript + jQuery
- **Build Tools**: Composer, npm, Sass
- **Testing**: PHPUnit
- **Quality Tools**: PHPStan, PHPCS

## Project Structure

```
duplicator-pro/
├── src/                      # Main plugin code (PSR-4: Duplicator\)
│   ├── Core/                 # Framework (Bootstrap, Controllers, Models)
│   ├── Controllers/          # Admin page controllers
│   ├── Models/              # Entity models
│   ├── Package/             # Package creation system
│   ├── Ajax/                # AJAX handlers
│   ├── Utils/               # Utilities and helpers
│   └── Libs/                # Internal libraries
├── addons/                   # Modular extensions (PSR-4: Duplicator\Addons\)
├── installer/                # Standalone installer (PSR-4: Duplicator\Installer\)
├── template/                 # MVC view templates
├── assets/                   # Frontend resources (CSS, JS, images)
├── vendor-prefixed/          # External libraries (namespace-prefixed)
├── tests/                    # PHPUnit test suite
└── duplicator-pro.php       # Plugin entry point
```

## Development Workflow

### Build Process
1. Sass compilation (`npm run build` / `npm run watch`)
2. Composer dependency management
3. PHPScoper for vendor namespace prefixing
4. Code quality checks (PHPStan, PHPCS)
5. PHPUnit test execution

### Package Creation Flow
```
Pre-Process → Scanning → Database Export → Archive Creation → Storage Processing → Complete
```

### Installer Restoration Flow
```
Validation → Extraction → Database Import → Search/Replace → Configuration → Final Tests
```

## Related Projects

- **Duplicator Free** - Free version with limited features
- **Duplicator Installer** - Standalone restoration script
- **Duplicator Cloud** - Cloud storage service integration (external)

## WordPress Integration

- Hooks into WordPress plugin system
- Admin menu integration
- Capability-based permissions
- Settings API for configuration
- Cron for scheduled backups
- REST API endpoints (future)

## Key Namespaces

```php
Duplicator\                   # Main plugin namespace
├── Core\                     # Core framework classes
├── Controllers\              # Admin controllers
├── Models\                   # Data models and entities
├── Package\                  # Package creation
├── Ajax\                     # AJAX handlers
└── Utils\                    # Utility classes

Duplicator\Addons\            # Addon extensions
Duplicator\Installer\         # Installer namespace
```
