<?php

namespace ElementorModal\Widgets;

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!class_exists('ElementorModal\Widgets\GT3_Core_Elementor_Widget_ImageAccordion')) {
	class GT3_Core_Elementor_Widget_ImageAccordion extends \ElementorModal\Widgets\GT3_Core_Widget_Base {

		public function get_name(){
			return 'gt3-core-imageaccordion';
		}

		public function get_title(){
			return esc_html__('Image Accordion', 'gt3_themes_core');
		}

		public function get_icon(){
			return 'gt3-core-elementor-icon eicon-slider-push';
		}

		public function get_repeater_fields() {
			$repeater = new Repeater();

			$repeater->add_control(
				'title',
				array(
					'label' => esc_html__('Title', 'gt3_themes_core'),
					'type'  => Controls_Manager::TEXT,
				)
			);

			$repeater->add_control(
				'content',
				array(
					'label' => esc_html__('Description', 'gt3_themes_core'),
					'type'  => Controls_Manager::WYSIWYG,
				)
			);

			$repeater->add_control(
				'link',
				[
					'label' => __( 'Link', 'gt3_themes_core' ),
					'type' => Controls_Manager::URL,
					'dynamic' => [
						'active' => true,
					],
					'placeholder' => __( 'https://your-link.com', 'gt3_themes_core' ),
				]
			);

			$repeater->add_control(
				'link_title',
				array(
					'label' => esc_html__('Link Title', 'gt3_themes_core'),
					'type'  => Controls_Manager::TEXT,
					'condition' => [
						'link[url]!' => '',
					],
					'default' => esc_html__('discover more', 'gt3_themes_core'),
				)
			);

			$repeater->add_control(
				'bg_image',
				array(
					'label'   => esc_html__('Background Image'),
					'type'    => Controls_Manager::MEDIA,
					'default' => array(
						'url' => Utils::get_placeholder_image_src(),
					),
				)
			);

			/* Image Icon */
			$repeater->add_control(
				'image',
				[
					'label' => __('Choose Image Icon', 'gt3_themes_core'),
					'type' => Controls_Manager::MEDIA,
					'dynamic' => [
						'active' => true,
					],
					'default' => [
						'url' => '',
					],
				]
			);

			$repeater->add_responsive_control(
				'image_size',
				[
					'label' => __('Image Width', 'gt3_themes_core'),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'size' => 100,
						'unit' => 'px',
					],
					'tablet_default' => [
						'unit' => 'px',
					],
					'mobile_default' => [
						'unit' => 'px',
					],
					'size_units' => [ 'px', '%' ],
					'range' => [
						'%' => [
							'min' => 5,
							'max' => 100,
						],
						'px' => [
							'min' => 5,
							'max' => 200,
						]
					],
					'selectors' => [
						'{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item{{CURRENT_ITEM}} .gt3-accordion-inner-wrap .gt3-accordion-wrapper-icon img' => 'max-width: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'image[url]!' => '',
					],
				]
			);

			$repeater->add_responsive_control(
				'image_space',
				[
					'label' => __('Image Spacing, px', 'gt3_themes_core'),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'size' => 110,
						'unit' => 'px',
					],
					'tablet_default' => [
						'unit' => 'px',
					],
					'mobile_default' => [
						'unit' => 'px',
					],
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 110,
						]
					],
					'selectors' => [
						'{{WRAPPER}} .gt3-accordion-wrapper .gt3-accordion-item{{CURRENT_ITEM}} .gt3-accordion-inner-wrap .gt3-accordion-wrapper-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'image[url]!' => '',
					],
				]
			);

			/* Image Icon End */

			return $repeater->get_controls();
		}

	}
}











