<?php

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Utils;

/** @var \ElementorModal\Widgets\GT3_Core_Elementor_Widget_ImageAccordion $widget */

$settings = array();

$settings = wp_parse_args($widget->get_settings(), $settings);

$css_class = array(
	'gt3-accordion-wrapper',
);

$widget->add_render_attribute('wrapper', 'class', $css_class);

if(is_array($settings['items']) && count($settings['items'])) {
?>
	<div <?php $widget->print_render_attribute_string('wrapper') ?>>
		<?php foreach($settings['items'] as $index => $item) { ?>
        <div class="gt3-accordion-item<?php echo $index === 0 ? ' active' : ''; ?> elementor-repeater-item-<?php echo $item['_id'] ?>">
	        <?php
		        /* Title */
		        if (!empty($item['title'])) {
			        echo '<span class="gt3-accordion-title">'.esc_html( $item['title'] ).'</span>';
		        }
		        /* BgImage */
		        $repeater_key_bg = $widget->get_repeater_key('bg_image', 'items', $index);
		        $bg_src = Utils::get_placeholder_image_src();
		        if(isset($item['bg_image']['id']) && (bool) $item['bg_image']['id']) {
			        $bg_image = wp_get_attachment_image_src($item['bg_image']['id'], 'single-post-thumbnail');
			        if($bg_image) {
				        $bg_src = $bg_image[0];
			        }
		        }
				$widget->add_render_attribute($repeater_key_bg, 'src', array(
			        sprintf('%s', esc_url($bg_src))
		        ));
		        echo '<div class="gt3-accordion-bg"><img ' . $widget->get_render_attribute_string($repeater_key_bg) . ' alt="'. (!empty($item['title']) ? esc_attr( $item['title'] ) : '') .'" /></div>';
	        ?>

			<div class="gt3-accordion-expanded">
				<div class="gt3-accordion-inner-wrap">
					<?php
					/* ImageIcon */
					$repeater_key_image = $widget->get_repeater_key('image', 'items', $index);
					$src = '';
					if(isset($item['image']['id']) && (bool) $item['image']['id']) {
						$image = wp_get_attachment_image_src($item['image']['id'], 'single-post-thumbnail');
						if($image) {
							$src = $image[0];
						}
					}
					if ($src) {
						$widget->add_render_attribute($repeater_key_image, 'src', array(
							sprintf('%s', esc_url($src))
						));
						$alt = !empty($item['image']['alt']) ? $item['image']['alt'] : 'image';
						$widget->add_render_attribute($repeater_key_image, 'alt', esc_attr($alt));
						?>
						<span class="gt3-accordion-wrapper-icon">
							<img <?php echo $widget->get_render_attribute_string($repeater_key_image) ?>>
						</span>
						<?php
					}
					/* Title */
					if (!empty($item['title'])) {
						echo '<div class="gt3-accordion-wrapper-title">'.esc_html( $item['title'] ).'</div>';
					}
					/* Description */
					if (!empty($item['content'])) {
						echo '<div class="gt3-accordion-text">'. $item['content'] .'</div>';
					}
					/* Link */
					if (!empty($item['link']['url'])) {
						$repeater_key_link = $widget->get_repeater_key('link', 'items', $index);
						$widget->add_render_attribute($repeater_key_link, 'href', $item['link']['url']);

						$widget->add_render_attribute($repeater_key_link, 'class', 'gt3-accordion-wrapper-btn');

						if ($item['link']['is_external']) {
							$widget->add_render_attribute($repeater_key_link, 'target', '_blank');
						}

						if (!empty($item['link']['nofollow'])) {
							$widget->add_render_attribute($repeater_key_link, 'rel', 'nofollow');
						}
						echo '<a ' . $widget->get_render_attribute_string($repeater_key_link) . '>' . ((!empty($item['link_title'])) ? $item['link_title'] : esc_html__('discover more', 'gt3_themes_core')) . '</a>';
					}
					?>
				</div>
			</div>
		</div>

		<?php } ?>
	</div>
<?php
}
