<?php

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

/** @var \ElementorModal\Widgets\GT3_Core_Elementor_Widget_TextSlider $widget */

$widget->start_controls_section(
	'section_content',
	array(
		'label' => esc_html__('Content', 'gt3_themes_core'),
	)
);

$repeater = new \Elementor\Repeater();

$repeater->add_control(
	'string', array(
		'label'       => esc_html__('String', 'gt3_themes_core'),
		'show_label'  => false,
		'type'        => Controls_Manager::TEXTAREA,
		'default'     => esc_html__('New Text', 'gt3_themes_core'),
		'label_block' => true,
	)
);

$widget->add_control(
	'text',
	array(
		'label'       => esc_html__('Text', 'gt3_themes_core'),
		'type'        => Controls_Manager::REPEATER,
		'default'     => array(
			array(
				'string' => esc_html__('Digital', 'gt3_themes_core'),
			),
			array(
				'string' => esc_html__('Marketing', 'gt3_themes_core'),
			),
			array(
				'string' => esc_html__('Business', 'gt3_themes_core'),
			),
		),
		'fields'      => $repeater->get_controls(),
		'title_field' => '{{{ string }}}',
	)
);

$widget->end_controls_section();

$widget->start_controls_section(
	'options_section',
	array(
		'label' => 'Options',
		'tab'   => Controls_Manager::TAB_SETTINGS,
	)
);

$widget->add_control(
	'interval',
	array(
		'label'       => esc_html__('Interval (ms)', 'gt3_themes_core'),
		'type'        => Controls_Manager::NUMBER,
		'step'        => 1000,
		'default'     => 3000,
		'min'         => 1000,
	)
);

$widget->add_control(
	'speed',
	array(
		'label'       => esc_html__('Speed (ms)', 'gt3_themes_core'),
		'type'        => Controls_Manager::NUMBER,
		'step'        => 100,
		'default'     => 600,
		'min'         => 100,
	)
);

$widget->add_control(
	'autoplay',
	array(
		'label'       => esc_html__('Autoplay', 'gt3_themes_core'),
		'type'        => Controls_Manager::SWITCHER,
		'default'     => 'yes',
	)
);

$widget->end_controls_section();

$widget->start_controls_section(
	'style_section',
	array(
		'label' => esc_html__('Style', 'gt3_themes_core'),
		'tab'   => Controls_Manager::TAB_STYLE,
	)
);

$widget->add_control(
	'text_color',
	array(
		'label'     => esc_html__('Color', 'gt3_themes_core'),
		'type'      => Controls_Manager::COLOR,
		'default' => '#E2E6EA',
	)
);

$widget->add_control(
	'text_color_active',
	array(
		'label'     => esc_html__('Color (Active Item)', 'gt3_themes_core'),
		'type'      => Controls_Manager::COLOR,
		'default' => '#062B3E',
		'condition' => array(
			'enable_theme_textgradient' => '',
		),
	)
);

$widget->add_control(
	'enable_theme_textgradient',
	array(
		'label'       => esc_html__('Enable Gradient (Active Item)?', 'gt3_themes_core'),
		'type'        => Elementor\Controls_Manager::SWITCHER,
		'description' => esc_html__('If checked, enable text color gradient', 'gt3_themes_core'),
		'default'     => '',
		'prefix_class' => 'gt3_theme_textgradient-',
	)
);
$widget->add_control(
	'textgradient_start',
	array(
		'label'   => esc_html__('Text Color Gradient Start','gt3_themes_core'),
		'type'    => Elementor\Controls_Manager::COLOR,
		'default' => '#D796FF',
		'condition' => array(
			'enable_theme_textgradient!' => '',
		),
	)
);
$widget->add_control(
	'textgradient_end',
	array(
		'label'   => esc_html__('Text Color Gradient End','gt3_themes_core'),
		'type'    => Elementor\Controls_Manager::COLOR,
		'default' => '#2683F4',
		'condition' => array(
			'enable_theme_textgradient!' => '',
		),
	)
);

$widget->add_group_control(
	Group_Control_Typography::get_type(),
	array(
		'name'     => 'text_typography',
		'selector' => '{{WRAPPER}} .gt3-text-slider .container .splide .gt3-text-slider-title',
	)
);

$widget->add_control(
	'module_overlay',
	array(
		'label'       => esc_html__('Background Overlay', 'gt3_themes_core'),
		'type'        => Controls_Manager::SWITCHER,
		'default'     => '',
		'description' => esc_html__('Allow the overlay of the block?', 'gt3_themes_core'),
	)
);

$widget->add_control(
	'heading_before',
	array(
		'label' => esc_html__('Before Overlay Settings', 'gt3_themes_core'),
		'type'  => Controls_Manager::HEADING,
		'condition'=> array(
			'module_overlay!' => '',
		),
	)
);

$widget->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	array(
		'name'     => 'background_overlay_before',
		'types'    => [ 'gradient' ],
		'selector' => '{{WRAPPER}} .gt3-text-slider .container .splide:before',
		'condition'=> array(
			'module_overlay!' => '',
		),
	)
);

$widget->add_control(
	'heading_after',
	array(
		'label' => esc_html__('After Overlay Settings', 'gt3_themes_core'),
		'type'  => Controls_Manager::HEADING,
		'condition'=> array(
			'module_overlay!' => '',
		),
	)
);

$widget->add_group_control(
	\Elementor\Group_Control_Background::get_type(),
	array(
		'name'     => 'background_overlay_after',
		'types'    => [ 'gradient' ],
		'selector' => '{{WRAPPER}} .gt3-text-slider .container .splide:after',
		'condition'=> array(
			'module_overlay!' => '',
		),
	)
);

$widget->add_responsive_control(
	'container_padding',
	array(
		'label'       => esc_html__('Container Left Padding, vw', 'gt3_themes_core'),
		'type'        => Controls_Manager::SLIDER,
		'default'     => array(
			'size' => 18,
			'unit' => 'vw',
		),
		'range'       => array(
			'vw' => array(
				'min'  => 0,
				'max'  => 50,
				'step' => 1,
			),
		),
		'size_units'  => array( 'vw' ),
		'label_block' => true,
		'selectors'   => array(
			'{{WRAPPER}} .gt3-text-slider .container' => 'padding-left: {{SIZE}}{{UNIT}};',
			'{{WRAPPER}} .gt3-text-slider .container .splide:after' => 'left: calc(-1 * {{SIZE}}{{UNIT}});',
		)
	)
);

$widget->end_controls_section();
