<?php

namespace WPDaddy\Builder\Elementor\Widgets\Logo;

if(!defined('ABSPATH')) {
	exit;
}

use Elementor\Utils;

trait Trait_Render {

	protected function render_widget(){
		$settings = array(
			'header_logo'        => array( 'url' => '', ),
			'logo_height_custom' => '',
			'logo_sticky'        => array( 'url' => '', ),
			'logo_custom_link' => '',
			'logo_custom_link_url' => array(
				'url'         => '#',
				'is_external' => false,
				'nofollow'    => false,
			),
		);

		$settings = wp_parse_args($this->get_settings(), $settings);

		/* Custom Logo URL */
		$link_url = esc_url(home_url('/'));
		if ($settings['logo_custom_link']) {
			if(empty($settings['logo_custom_link_url']['url'])) {
				$settings['logo_custom_link_url']['url'] = '#';
			}

			if($settings['logo_custom_link_url']['is_external']) {
				$this->add_render_attribute('href', 'target', '_blank');
			}
			if(!empty($settings['logo_custom_link_url']['nofollow'])) {
				$this->add_render_attribute('href', 'rel', 'nofollow');
			}

			$link_url =esc_url($settings['logo_custom_link_url']['url']);
		}

		$this->add_render_attribute('href', 'aria-label', esc_html__( 'Logo', 'wpda-builder' ));

		$this->add_render_attribute('href', 'href',$link_url );

		/* Custom Logo URL End */


		$logoSizes = '';
		if (isset($settings['logo_height']) && $settings['logo_height']) {
			$logoSizes = '';
		}



		$enable_sticky = false;
		if(isset($settings['header_logo']['url']) && !empty($settings['header_logo']['url'])) {
			$header_logo = $settings['header_logo']['url'];

			if($header_logo) {
				$header_logo_array = wp_prepare_attachment_for_js($settings['header_logo']['id']);
				if (!is_null($header_logo_array)) {
					$header_width = (is_array($header_logo_array) && !empty($header_logo_array['width'])) ? esc_attr($header_logo_array['width']) : '';
					$header_height = (is_array($header_logo_array) && !empty($header_logo_array['height'])) ? esc_attr($header_logo_array['height']) : '';
					$header_logo   = '<img class="wpda-builder-logo" src="'.esc_url($header_logo).'" alt="'.esc_attr($header_logo_array['alt']).'" title="'.esc_attr($header_logo_array['title']).'" width="'.$header_width.'" height="'.$header_height.'"/>';
					$enable_sticky = true;
				}  else {
					$header_logo = '';
				}
			}
		} else {
			$header_logo = '<span class="wpda-builder-site_title">'.get_bloginfo('name').'</span>';
		}
		if(isset($settings['logo_sticky']['url']) && !empty($settings['logo_sticky']['url'])) {
			$logo_sticky = $settings['logo_sticky']['url'];
			if($logo_sticky) {
				$sticky_logo_array = wp_prepare_attachment_for_js($settings['logo_sticky']['id']);
				if (!is_null($sticky_logo_array)) {
					$sticky_width = (is_array($sticky_logo_array) && !empty($sticky_logo_array['width'])) ? esc_attr($sticky_logo_array['width']) : '';
					$sticky_height = (is_array($sticky_logo_array) && !empty($sticky_logo_array['height'])) ? esc_attr($sticky_logo_array['height']) : '';
					$logo_sticky = '<img class="wpda-builder-logo_sticky" src="'.esc_url($logo_sticky).'"  alt="'.esc_attr($sticky_logo_array['alt']).'" title="'.esc_attr($sticky_logo_array['title']).'" width="'.$sticky_width.'" height="'.$sticky_height.'" />';
				} else {
					$logo_sticky = '';
				}
			}
		} else {
			$logo_sticky = '';
		}
		if(!$enable_sticky) {
			$logo_sticky = '';
		}

		$this->add_render_attribute(
			'wrapper', 'class', array(
				'wpda-builder-logo_container',
				($logo_sticky && $header_logo) ? 'has_sticky_logo' : '',
			)
		);

		?>
		<div <?php $this->print_render_attribute_string('wrapper') ?>>
			<a <?php $this->print_render_attribute_string('href') ?>>
				<?php echo $header_logo.$logo_sticky; ?>
			</a>
		</div>
		<?php
	}
}

