/**
 * Child Theme Installer JavaScript
 * Save this as: wp-content/themes/your-theme/js/child-theme-installer.js
 */

jQuery(document).ready(function($) {

    // Install button handler
    jQuery(document).on('click', '#gt3-install-child-theme', function(e) {
        e.preventDefault();

        var $btn = jQuery(this);
        var $progressContainer = jQuery('#gt3-progress-container');
        var $progressFill = jQuery('#gt3-progress-fill');
        var $progressMessage = jQuery('#gt3-progress-message');

        // Disable button and show progress
        $btn.prop('disabled', true).text('Installing...');
        $progressContainer.show();
        updateProgress(0, 'Preparing to download...');

        // Start installation
        $.ajax({
            url: gt3ChildTheme.ajax_url,
            type: 'POST',
            data: {
                action: 'gt3_install_child_theme',
                nonce: gt3ChildTheme.nonce
            },
            dataType: 'json',
            beforeSend: function() {
                updateProgress(10, 'Connecting to server...');
            },
            success: function(response) {
                if (response && response.success) {
                    updateProgress(75, 'Installing child theme...');

                    setTimeout(function() {
                        updateProgress(90, 'Finalizing installation...');

                        setTimeout(function() {
                            updateProgress(100, response.data.message || 'Installation complete!');
                            $progressMessage.addClass('gt3-success-message');

                            // Now activate the theme
                            setTimeout(function() {
                                activateChildTheme();
                            }, 1000);
                        }, 500);
                    }, 500);
                } else {
                    var errorMsg = 'Installation failed. Please try again.';
                    if (response && response.data && response.data.message) {
                        errorMsg = response.data.message;
                    }
                    showError(errorMsg);
                    $btn.prop('disabled', false).text('Install Theme');
                }
            },
            error: function(xhr, status, error) {
                showError('An error occurred during installation: ' + error);
                $btn.prop('disabled', false).text('Install Theme');
            }
        });
    });

    // Activate button handler
    jQuery(document).on('click', '#gt3-activate-child-theme', function(e) {
        e.preventDefault();

        var $btn = jQuery(this);
        var $progressContainer = jQuery('#gt3-progress-container');

        $btn.prop('disabled', true).text('Activating...');
        $progressContainer.show();
        updateProgress(50, 'Activating child theme...');

        activateChildTheme();
    });

    // Function to activate child theme
    function activateChildTheme() {
        var $progressFill = jQuery('#gt3-progress-fill');
        var $progressMessage = jQuery('#gt3-progress-message');

        updateProgress(80, 'Activating child theme...');

        $.ajax({
            url: gt3ChildTheme.ajax_url,
            type: 'POST',
            data: {
                action: 'gt3_activate_child_theme',
                nonce: gt3ChildTheme.nonce
            },
            success: function(response) {
                if (response && response.success) {
                    updateProgress(100, response.data.message || 'Activation complete!');
                    $progressMessage.addClass('gt3-success-message');

                    // Redirect after 1.5 seconds
                    setTimeout(function() {
                        localStorage.setItem('gt3_auto_click_demo', '1');
                        window.location.href = gt3ChildTheme.redirect_url;
                    }, 1500);
                } else {
                    var errorMsg = 'Activation failed. Please try again.';
                    if (response && response.data && response.data.message) {
                        errorMsg = response.data.message;
                    }
                    showError(errorMsg);
                }
            },
            error: function(xhr, status, error) {
                showError('An error occurred during activation: ' + error);
            }
        });
    }

    // Update progress bar
    function updateProgress(percent, message) {
        var $progressFill = jQuery('#gt3-progress-fill');
        var $progressMessage = jQuery('#gt3-progress-message');

        $progressFill.css('width', percent + '%').text(Math.round(percent) + '%');
        $progressMessage.text(message).removeClass('gt3-error-message gt3-success-message');
    }

    // Show error message
    function showError(message) {
        var $progressMessage = jQuery('#gt3-progress-message');
        var $progressFill = jQuery('#gt3-progress-fill');

        $progressFill.css('width', '100%').css('background-color', '#f46a6a');
        $progressMessage.text(message).addClass('gt3-error-message');
    }

    if (localStorage.getItem('gt3_auto_click_demo') === '1') {
        localStorage.removeItem('gt3_auto_click_demo');

        setTimeout(function() {
            var clickInterval = setInterval(function() {
                var $demoTab = jQuery('a.demo_import.nav-link');
                if ($demoTab.length) {
                    $demoTab.get(0).click();
                    clearInterval(clickInterval);
                }
            }, 300);

            setTimeout(function() {
                clearInterval(clickInterval);
            }, 5000);
        }, 100);
    }

});
